##################################################################
# Description:   Tells about the news on given site              #
# Author:        Norbert Kuemin <norbert.kuemin@gmx.net>         #
# Copyright:     Copyright 2001 by Norbert Kuemin                #
##################################################################
# Version   Date         Description                             #
#    1.00   04.06.2001   Initial coding                          #
##################################################################

package modules::slashcode;

$VERSION = "1.00";
$NAME = "Slashcode";
$MODULE = "modules::slashcode";

use lib '/home/slash';
use Slash;
use Text::Wrap qw(wrap $columns $huge);

$columns = 60;
$huge = 'wrap';

sub new {
   my $proto = shift;

   my $conn = undef;
   if (scalar(@_) > 0) {
      $conn = shift;
   }

   my $config = undef;
   if (scalar(@_) > 0) {
      $config = shift;
   }

   my $eventhandler = undef;
   if (scalar(@_) > 0) {
      $eventhandler = shift;
   }

   my $modulehandler = undef;
   if (scalar(@_) > 0) {
      $modulehandler = shift;
   }

   my $self = {
      '_config'            => $config,
      '_connection'        => $conn,
      '_eventhandler'      => $eventhandler,
      '_modulehandler'     => $modulehandler,
      '_events'            => 'msg public slash_news slash_submit',
      '_lastnews'          => undef,
      '_lastsubmit'        => undef,
      '_newsinterval'      => 0,
      '_newschannel'       => "",
      '_newstext'          => "",
      '_submitinterval'    => 0,
      '_submitchannel'     => "",    
      '_submitchannelfile' => "",
      '_submitchannelfilemtime' => 0,
      '_submittext'        => "",
      '_submitcount'       => 0,
      '_site'              => ""
   };
   bless $self, $proto;

   if (defined($config)) {
      if (defined($config->get('SLASHNEWSINTERVAL'))) {
         $self->{'_newsinterval'} = $config->get('SLASHNEWSINTERVAL');
      }
      if (defined($config->get('SLASHNEWSCHANNEL'))) {
         $self->{'_newschannel'} = $config->get('SLASHNEWSCHANNEL');
      }
      if (defined($config->get('SLASHNEWSTEXT'))) {
         $self->{'_newstext'} = $config->get('SLASHNEWSTEXT');
      }
      if (defined($config->get('SLASHSUBMITINTERVAL'))) {
         $self->{'_submitinterval'} = $config->get('SLASHSUBMITINTERVAL');
      }
      if (defined($config->get('SLASHSUBMITCHANNEL'))) {
         $self->{'_submitchannel'} = $config->get('SLASHSUBMITCHANNEL');
      }
      if (defined($config->get('SLASHSUBMITCHANNELFILE'))) {
         $self->{'_submitchannelfile'} = $config->get('SLASHSUBMITCHANNELFILE');
      }
      if (defined($config->get('SLASHSUBMITTEXT'))) {
         $self->{'_submittext'} = $config->get('SLASHSUBMITTEXT');
      }
   }
   $self->init();

   return $self;
}

sub on_public {
   $self = shift;
   my ($channel, $nick, $userhost, $text) = @_;
   $self->do_cmd($nick, $userhost, $text);
}

sub on_msg {
   $self = shift;
   my ($nick, $userhost, $text) = @_;
   $self->do_cmd($nick, $userhost, $text);
}

sub get_version {
   return $VERSION;
}

sub get_name {
   return $NAME;
}

sub get_module {
   return $MODULE;
}

sub get_events {
   $self = shift;
   return $self->{'_events'};
}

sub init {
   $self = shift;
   *I = getSlashConf();
   getSlash();
   $self->{'_site'} = $I{sitename};
   ($self->{'_lastnews'}) = sqlSelect("time", "newstories", "displaystatus=0 AND time < now()", "ORDER BY time DESC LIMIT 1");
   ($self->{'_lastsubmit'}) = sqlSelect("time", "submissions", "", "ORDER BY time DESC LIMIT 1");
   $self->{'_eventhandler'}->timer_add("slash_news",$self->{'_newsinterval'});
   $self->{'_eventhandler'}->timer_add("slash_submit",$self->{'_submitinterval'});
   if ($self->{'_submitchannelfile'} ne "") {
      $self->load_submitchannel();
   }
}

sub load_submitchannel {
   $self = shift;
   # Loading data
   if (-r $self->{'_submitchannelfile'}) {
      my ($dev,$ino,$mode,$nlink,$uid,$gid,$rdev,$size,$atime,$mtime,$ctime,$blksize,$blocks) = stat($self->{'_submitchannelfile'});
      $self->{'_submitchannelfilemtime'} = $mtime;
      open FD, $self->{'_submitchannelfile'} or die "Seen: Error reading '".$self->{'_submitchannelfile'}."'.\n";
      while (<FD>) {
         chomp;
         if (substr($_,0,1) ne "#") {
            if ($self->{'_submitchannel'} ne "") {
               $self->{'_submitchannel'} = $self->{'_submitchannel'}.",";
            }
            $self->{'_submitchannel'} = $self->{'_submitchannel'}.$_
         }
      }
      close FD;
   }
}

sub do_cmd {
   $self = shift;
   my ($nick, $userhost, $text) = @_;
   my $cmd = uc($self->{'_config'}->get('COMMANDPREFIX')."NEWS");
   my $search = substr(uc($text),0,length($cmd));
   if ($search eq $cmd) {
      my @parm = split(" ",uc($text));
      if (scalar(@parm) == 1) {
         $self->list_news($nick,10);
      } else {
         $self->disp_news($nick,$parm[1]." ".$parm[2]);
      }
   }
   $cmd = uc($self->{'_config'}->get('COMMANDPREFIX')."HELP");
   $search = substr(uc($text),0,length($cmd));
   if ($search eq $cmd) {
      $_ = substr($text,length($cmd));
      s/^\s+//;
      s/\s+$//;
      $self->help($nick,$_);
   }
}
sub on_slash_news {
   $self = shift;
   # News alert
   my $c = sqlSelectMany("title,aid,time", "newstories", "time > '".$self->{'_lastnews'}."' AND displaystatus=0 AND time < now()", "ORDER BY time");
   my $first = 1;
   while (my($title,$author,$time) = $c->fetchrow()) {
      $self->{'_lastnews'} = $time;
      $title = $self->decode($title);
      if ($first == 1) {
         $first = 0;
         $self->{'_connection'}->privmsg($self->{'_newschannel'},$self->{'_newstext'});
      }
      $self->{'_connection'}->privmsg($self->{'_newschannel'},"$title ($author)");
   }
   $c->finish;
}

sub on_slash_submit {
   $self = shift;
   # Submission alert
   $c = sqlSelectMany("subj,time,name", "submissions", "time > '".$self->{'_lastsubmit'}."'", "ORDER BY time");
   my $first = 1;
   my ($dev,$ino,$mode,$nlink,$uid,$gid,$rdev,$size,$atime,$mtime,$ctime,$blksize,$blocks) = stat($self->{'_submitchannelfile'});
   if ($self->{'_submitchannelfilemtime'} != $mtime) {
      # reload submit channels
      if (defined($self->{'_config'}->get('SLASHSUBMITCHANNEL'))) {
         $self->{'_submitchannel'} = $config->get('SLASHSUBMITCHANNEL');
      } else {
         $self->{'_submitchannel'} = "";
      }
      if ($self->{'_submitchannelfile'} ne "") {
         $self->load_submitchannel();
      }
   }

   while (my($title,$time,$name) = $c->fetchrow()) {
      $self->{'_lastsubmit'} = $time;
      $title = $self->decode($title);
      if (index(";".$self->{'_config'}->get('SLASHSUBMITIGNORE').";",";".$title.";") == -1) {
         if ($first == 1) {
            $first = 0;
            $self->{'_connection'}->privmsg($self->{'_submitchannel'},$self->{'_submittext'});
         } 
         $self->{'_connection'}->privmsg($self->{'_submitchannel'},"$time $title ($name)");
      }
   }
   $c->finish;
}

sub list_news {
   $self = shift;
   my ($to,$limit) = @_;
   my $c = sqlSelectMany("title,aid,time", "newstories", "displaystatus=0 AND time < now()", "ORDER BY time DESC LIMIT $limit");
   my $first = 1;
   while (my($title,$author,$time) = $c->fetchrow()) {
      $title = $self->decode($title);
      $self->{'_connection'}->privmsg($to,"$time $title ($author)");
      sleep 1;
   }
   $c->finish;
}

sub disp_news {
   $self = shift;  
   my ($to,$what) = @_;
   my $where = "displaystatus=0 AND time < now()";
   if ($what ne "LATEST ") {
      $where = $where." AND time='$what'";
   }
   if (my ($sid,$title,$introtext,$bodytext,$date,$time,$author) = sqlSelect("sid,title,introtext,bodytext,date_format(time,\"%W, %d. %M %H:%i\"),time,aid","newstories", $where, "ORDER BY time DESC LIMIT 1")) {
      # header
      $title = $self->decode($title);
      $self->{'_connection'}->privmsg($to,"Subject: $title");
      $self->{'_connection'}->privmsg($to,"Date: $date");
      sleep 1;
      $self->{'_connection'}->privmsg($to,"Author: $author");
      $self->{'_connection'}->privmsg($to,"--------------------");
      sleep 1;
      $_ = "$introtext $bodytext";
      s/\n//g;
      s/\r//g;
      s/\<br\>/\n/g;
      s/\<BR\>/\n/g;
      s/\<p\>/\n\n/g;
      s/\<P\>/\n\n/g;
      $text = $self->removetag($_);
      $text = $self->decode($text);
      my @lines = split("\n",wrap("","",$text));
      foreach (@lines) {
         if ($_ eq "") { $_ = " "; }
         $self->{'_connection'}->privmsg($to,$_);
      }
      $self->{'_connection'}->privmsg($to," ");
      $self->{'_connection'}->privmsg($to,"Story: http://".$self->{'_site'}."/article.pl?sid=$sid");
      $self->urllist($to,$title,$introtext,$bodytext);
   } else {
      $self->{'_connection'}->privmsg($to,"No story found from '$what'");
   }
}

sub urllist {
   $self = shift;
   $to = shift;
   my $showtitle = 1;
   foreach (@_) {
      $_ = lc($_);
      while (index($_,"<") > -1) {
         $_ = substr($_,index($_,"<")+1);
         my $rest = substr($_,index($_,">")+1);
         $_ = substr($_,0,index($_,">"));
         if (/a\ (.*)href\=([^\ ]*)/) {
            $_ = $2;
            s/\"//g;
            if ($showtitle) {
               $self->{'_connection'}->privmsg($to," ");
               $self->{'_connection'}->privmsg($to,"Links:");
               $showtitle = 0;
            }
            if (/([^\/^\:]*)\:(.*)$/) {
               if ($1 ne "mailto") {   
                  $self->{'_connection'}->privmsg($to,$_);
               }
            } else {
               my $url = "http://".$self->{'_site'}.$_;
               $self->{'_connection'}->privmsg($to,$url);
            }
         }
         $_ = $rest;
      }
   }   
}

sub decode {
   $self = shift;
   my ($text) = @_;
   $_ = $text;
   s/\&auml\;//g;
   s/\&ouml\;//g;
   s/\&uuml\;//g;
   s/\&Auml\;//g;
   s/\&Ouml\;//g;
   s/\&Uuml\;//g;
   s/\&lt\;/\</g;
   s/\&gt\;/\>/g;
   s/\&ampr\;/\&/g;
   return $_;
}

sub removetag {
   $self = shift;
   my ($text) = @_;
   my $ret = "";
   foreach (split("\n",$text)) {
      while (/(.*)\<([^\>]*)\>(.*)/) { $_ = $1.$3; }
      if ($ret ne "") { $ret = $ret."\n"; }
      $ret = $ret.$_;
   }
   return $ret;
}

sub help {
   $self = shift;
   my $nick = shift;
   if (scalar(@_) > 0) {
      $cmd = lc(shift);
   }
   if (length($cmd) > 0) {
      if ($cmd eq "news") {
         $self->{'_connection'}->privmsg($nick,"news        - List latest news.");
         $self->{'_connection'}->privmsg($nick,"news latest - Display last news entry.");
         $self->{'_connection'}->privmsg($nick,"news <time> - Display selected news entry.");
      }
   } else {
      # print list
      $self->{'_connection'}->privmsg($nick,"news            - Latest news from selected slashcode-site");
   }
}
