##################################################################
# Description:   Following invites                               #
# Author:        Norbert Kuemin <norbert.kuemin@gmx.net>         #
# Copyright:     Copyright 2001 by Norbert Kuemin                #
##################################################################
# Version   Date         Description                             #
#    1.00   05.08.2001   Initial coding                          #
##################################################################

package modules::invite;

$VERSION = "1.00";
$NAME = "Invite";
$MODULE = "modules::invite";

sub new {
   my $proto = shift;

   my $conn = undef;
   if (scalar(@_) > 0) {
      $conn = shift;
   }

   my $config = undef;
   if (scalar(@_) > 0) {
      $config = shift;
   }

   my $eventhandler = undef;
   if (scalar(@_) > 0) {
      $eventhandler = shift;
   }

   my $modulehandler = undef;
   if (scalar(@_) > 0) {
      $modulehandler = shift;
   }

   my $self = {
         '_config'        => $config,
         '_connection'    => $conn,
         '_eventhandler'  => $eventhandler,
         '_modulehandler' => $modulehandler,
         '_events'        => 'invite public join',
         '_invitelist'    => undef
   };
   bless $self, $proto;

   return $self;
}

sub on_join {
   $self = shift;
   my ($channel, $nick, $userhost) = @_;
   my $botname = lc($self->{'_connection'}->nick());
   if ($botname eq $nick) {
      if (!defined($self->{'_invitelist'}->{$channel})) {
         $self->{'_invitelist'}->{$channel} = $botname;
      }
   }
}

sub on_invite {
   $self = shift;
   my ($channel, $nick, $userhost) = @_;
   if (!defined($self->{'_invitelist'}->{$channel})) {
      $self->{'_invitelist'}->{$channel} = lc($nick);
   }
   $self->{'_connection'}->join($channel);
}

sub on_public {
   $self = shift;
   my ($channel, $nick, $userhost, $text) = @_;
   my $cmd = uc($self->{'_config'}->get('COMMANDPREFIX')."LEAVE");
   my $search = uc($text);
   if (($search eq $cmd) || ($search eq $cmd." ".uc($self->{'_connection'}->nick()))) {
      if (defined($self->{'_invitelist'}->{$channel})) {
         if ($self->{'_invitelist'}->{$channel} eq lc($nick)) {
            delete($self->{'_invitelist'}->{$channel});
            $self->{'_connection'}->part($channel);
            return;
         }
      }
      my $userhandler = $self->{'_modulehandler'}->get("modules::user");
      if (defined($userhandler)) {
         if ($userhandler->checkmode(lc($nick),"m") == 1) {
            delete($self->{'_invitelist'}->{$channel});
            $self->{'_connection'}->part($channel);
         }
      }
   }
}

sub get_version {
   return $VERSION;
}

sub get_name {
   return $NAME;
}

sub get_module {
   return $MODULE;
}

sub get_events {
   $self = shift;
   return $self->{'_events'};
}
