##################################################################
# Description:   Logging activities on IRC                       #
# Author:        Norbert Kuemin <norbert.kuemin@gmx.net>         #
# Copyright:     Copyright 2000 by Norbert Kuemin                #
##################################################################
# Version   Date         Description                             #
#    1.00   23.07.2000   Initial coding                          #
##################################################################

package modules::email;

$VERSION = "1.00";
$NAME = "eMail";
$MODULE = "modules::email";

sub new {
   my $proto = shift;

   my $conn = undef;
   if (scalar(@_) > 0) {
      $conn = shift;
   }

   my $config = undef;
   if (scalar(@_) > 0) {
      $config = shift;
   }

   my $eventhandler = undef;
   if (scalar(@_) > 0) {
      $eventhandler = shift;
   }

   my $modulehandler = undef;
   if (scalar(@_) > 0) {
      $modulehandler = shift;
   }

   my $self = {
         '_config'        => $config,
         '_connection'    => $conn,
         '_eventhandler'  => $eventhandler,
         '_modulehandler' => $modulehandler,
         '_events'        => 'email_check',
         '_checktime'     => undef
   };
   bless $self, $proto;

   if (defined($config)) {
      if (defined($config->get('EMAILCHECKINTERVAL'))) {
         $self->{'_checktime'} = $config->get('EMAILCHECKINTERVAL');
         $eventhandler->timer_add("email_check",$self->{'_checktime'});
      }
   }

   return $self;
}

sub on_ping {
   $self = shift;
   $self->mail_check();
}

sub get_version {
   return $VERSION;
}

sub get_name {
   return $NAME;
}

sub get_module {
   return $MODULE;
}

sub get_events {
   $self = shift;
   return $self->{'_events'};
}

sub on_email_check {
   $self = shift;
   # Read mail
   open(MAILBOX, "<".$ENV{MAIL});
   open(RECEIVED, ">>".$ENV{HOME}."/received");
   my $headers = 0;
   my %HEAD;
   my $text = "";
   my $lastheadkey = "";
   while (<MAILBOX>) {
      print RECEIVED $_;
      if ($headers == 1) {
         if (/^$/) {
            $headers = 0;
         } else {
            chomp;
            my $firstchar = substr($_,0,1);
            if (($firstchar eq " ") && ($lastheadkey ne "")) {
               $HEAD{$lastheadkey} = $HEAD{$lastheadkey}.substr($_,0,1,"");
            } elsif (($firstchar eq "\t") && ($lastheadkey ne "")) { 
               $HEAD{$lastheadkey} = $HEAD{$lastheadkey}." ".substr($_,0,1,"");
            } elsif (/([^\:]*)\:\ (.*)/) {
               $lastheadkey = $1;
               $HEAD{$1} = $2;
            }
         }
      } else {
         if (/^From /) {# all mail blocks start with From 
            $headers = 1;
            if (defined($HEAD{From})) {
               my ($email,$name) = $self->mail_sender($HEAD{From});
               $self->{'_eventhandler'}->action("mail",$email,$name,$HEAD{Subject},$text);
               $text = "";
               %HEAD = {};

            }
         } else {
            $text = $text.$_;
         }
      }
   }
   close(MAILBOX);
   close(RECEIVED);
   if (defined($HEAD{From})) {
      my ($email,$name) = $self->mail_sender($HEAD{From});
      $self->{'_eventhandler'}->action("mail",$email,$name,$HEAD{Subject},$text);
   }
   open(MAILBOX, ">".$ENV{MAIL});
   close(MAILBOX);
}

sub mail_sender {
   $self = shift;
   my $from = shift;
   $_ = $from;
   my $name = "";
   my $email = "";
   if (/(.*)\ \<([^\>]*)\>/) {
      $name = $1;
      $email = $2;
   } elsif (/(.*)\ \(([^\)]*)\)/) {
      $name = $2;
      $email = $1;
   } else {
      $email = $_;
   }
   return ($email,$name);
}
