##################################################################
# Description:   Handling the events for yabba                   #
# Author:        Norbert Kuemin <norbert.kuemin@gmx.net>         #
# Copyright:     Copyright 2000 by Norbert Kuemin                #
##################################################################
# Version   Date         Description                             #
#     1.0   15.07.2000   Initial coding                          #
##################################################################

package NoK::event;

$DEBUG = 0;
$VERSION = "1.00";

sub new {
   my $proto = shift;
   my $file = shift;

   my $self = {
         '_event'     => (),
         '_handle'    => (),
         '_timerdef'  => undef,
         '_timerlist' => undef
      };

   bless $self, $proto;

   $SIG{'ALRM'} = sub { $self->timer_check() };
   alarm(60);

   return $self;
}

sub add {
   $self = shift;
   my ($event, $code) = @_;
   *EVENT = $self->{'_event'};
   *HANDLE = $self->{'_handle'};
   my $size = scalar(@EVENT);
   $EVENT[$size] = $event;
   $HANDLE[$size] = $code;
   if ($DEBUG) { print "D: add ".$EVENT[$i]." ($i) $code\n"; }
}

sub action {
   my $self = shift;
   my $event = shift;
   if ($DEBUG) { print "D: event '$event'\n"; }
   *EVENT = $self->{'_event'};
   *HANDLE = $self->{'_handle'};
   my $size = scalar(@EVENT);
   if ($size > 0) {
      for(my $i=0 ; $i<$size ; $i++) {
         my $sevent = $EVENT[$i];
         my $scode = $HANDLE[$i];
         if ($sevent eq $event) {
            if ($DEBUG) { print "D: exec ".$scode->get_name()."->on_$event ($i)\n"; }
            eval "\$"."scode->on_$event(\@_)";
            if($@) { print "Error: ".$@."\n"; }
         }
      }
   }
}

sub remove_module {
   $self = shift;
   my ($code) = @_;
   *EVENT = $self->{'_event'};
   *HANDLE = $self->{'_handle'};
   my $size = scalar(@EVENT);
   if ($size > 0) {
      for(my $i=0 ; $i<$size ; $i++) {
         my $scode = $HANDLE[$i];
         if ($scode eq $code) {
            if ($DEBUG) { print "D: remove ".$EVENT[$i]." ($i)\n"; }
            undef $HANDLE[$i];
            undef $EVENT[$i];
         }
      }
   }
}

sub timer_add {
   $self = shift;  
   my ($name,$interval) = @_;
   if ($interval < 1) { return; }
   $self->{'_timerdef'}->{$name} = $interval;
   $self->{'_timerlist'}->{$name} = time() + ($interval * 60);
   if ($DEBUG) { print "D: add timer ".$name." ($interval)\n"; }
}

sub timer_del {
   $self = shift;  
   my ($name) = @_;
   if (defined($self->{'_timerdef'}->{$name})) {
      delete $self->{'_timerdef'}->{$name};
   }
   if (defined($self->{'_timerlist'}->{$name})) {
      delete $self->{'_timerlist'}->{$name};
   }
   if ($DEBUG) { print "D: del timer ".$name."\n"; }    
}

sub timer_check {
   $self = shift;
   alarm(60);
   *TIMER = $self->{'_timerdef'};
   foreach $name (keys %TIMER) {
      if ($self->{'_timerlist'}->{$name} <= time()) {
         if ($DEBUG) { print "D: fire timer event ".$name."\n"; }
         $self->action($name);
         while ($self->{'_timerlist'}->{$name} <= time()) {
            $self->{'_timerlist'}->{$name} = $self->{'_timerlist'}->{$name} + ($self->{'_timerdef'}->{$name} * 60);
         }
      }
   }
}
